import numpy as np
import pandas as pd
import os

data_path = '/Users/wangzhenlei/Desktop/Weight Uncertainty in Individual Treatment Effect/Experiments/UITE/dataset'
train_file = os.path.join(data_path,'jobs_DW_bin.new.10.train.npz')
test_file = os.path.join(data_path,'jobs_DW_bin.new.10.test.npz')

train = np.load(train_file,allow_pickle=True)
test = np.load(test_file,allow_pickle=True)


saved_path = os.path.join(data_path,'Jobs')

index_columns = ['e','yf', 't', 'x']
data_nums = 10
for index in range(data_nums):

    cur_name = os.path.join(saved_path,'Jobs'+str(index+1)+'.csv')
    treatment = np.append(train['t'][:,index],test['t'][:,index],axis=0)
    yf = np.append(train['yf'][:, index], test['yf'][:, index], axis=0)
    e = np.append(train['e'][:, index], test['e'][:, index], axis=0)
    x = np.append(train['x'][:,:, index], test['x'][:,:, index], axis=0)

    cur_data = {
        'treatment':treatment,
        'yf': yf,
        'e': e
    }
    for x_index in range(17):
        cur_data['x'+str(x_index+1)] = x[:,x_index]
    # print(cur_data)
    # pd.DataFrame(cur_data).to_csv(cur_name,index=False)

